(function() {
    "use strict";

    var showErrorMessage = function (response) {
        JIRA.Messages.showErrorMsg(JIRA.SmartAjax.buildSimpleErrorContent(response), {
            closeable: true
        });
    };

    var loadContentFor = function (url, el) {
        return AJS.$.ajax({
            url: url,
            type: "GET"
        }).done(function (html) { el.html(html); }).fail(showErrorMessage);
    };

    var Navigation = function () {
        return _.extend({
            start: function (el, subnavigator, router) {
                var self = this;

                var projectKey = encodeURIComponent(JIRA.API.Projects.getCurrentProjectKey());
                var baseUrl = AJS.contextPath() + "/projects/" + projectKey;

                var updatePageContent = function (contentUrl, subnavigatorSelectedItem) {
                    var url = baseUrl + contentUrl;
                    loadContentFor(url, el).done(function () {
                        self.trigger("pageRefreshed");
                        subnavigator.selectItem(subnavigatorSelectedItem);
                    });
                };

                router.on("statistics", function () {
                    updatePageContent("?selectedItem=com.atlassian.jira.jira-projects-plugin:issues-panel&decorator=none&contentOnly=true", "statistics");
                    self.trigger("statisticsPageSelected");
                });

                router.on("activity", function () {
                    updatePageContent("?selectedItem=com.atlassian.jira.jira-projects-plugin:project-activity-summary&decorator=none&contentOnly=true", "activity");
                    self.trigger("activityPageSelected");
                });

                subnavigator.on("itemSelected", function (e) {
                    var itemId = e.item.id;
                    if (itemId === "statistics") {
                        router.goToStatistics();
                    }
                    else {
                        router.goToActivity();
                    }
                });

                subnavigator.show();
            }
        }, Backbone.Events);
    };

    AJS.namespace("JIRA.Projects.Summary.Navigation");
    JIRA.Projects.Summary.Navigation.create = function() {
        return new Navigation();
    };
}());
