AJS.test.require("com.atlassian.jira.jira-projects-plugin:summary-page-navigation-test",function(){module("JIRA.Projects.Summary.Navigation",{setup:function(){this.sandbox=sinon.sandbox.create();this.subnavigator=JIRA.Projects.Summary.Subnavigator.create(AJS.$("<div/>"),AJS.$("<div/>"));this.router=JIRA.Projects.Summary.Router.create();this.el=AJS.$("<div/>");this.navigation=JIRA.Projects.Summary.Navigation.create();this.server=this.sandbox.useFakeServer();this.mockCurrentProject()},teardown:function(){this.sandbox.restore()},startNavigation:function(){this.navigation.start(this.el,this.subnavigator,this.router)},mockCurrentProject:function(){this.sandbox.stub(JIRA.API.Projects,"getCurrentProjectKey").returns("KEY")},serverReturnsHtmlForStatisticsPage:function(a){this.mockServerResponse(/\/projects\/KEY\?selectedItem=com.atlassian.jira.jira-projects-plugin:issues-panel&decorator=none&contentOnly=true*/,[200,{"Content-Type":"text/html"},a])},serverReturnsErrorForStatisticsPage:function(){this.mockServerResponse(/\/projects\/KEY\?selectedItem=com.atlassian.jira.jira-projects-plugin:issues-panel&decorator=none&contentOnly=true*/,[500,{"Content-Type":"text/html"},"error"])},serverReturnsHtmlForActivityPage:function(a){this.mockServerResponse(/\/projects\/KEY\?selectedItem=com.atlassian.jira.jira-projects-plugin:project-activity-summary&decorator=none&contentOnly=true*/,[200,{"Content-Type":"text/html"},a])},serverReturnsErrorForActivityPage:function(){this.mockServerResponse(/\/projects\/KEY\?selectedItem=com.atlassian.jira.jira-projects-plugin:project-activity-summary&decorator=none&contentOnly=true*/,[500,{"Content-Type":"text/html"},"error"])},mockServerResponse:function(b,a){this.server.respondWith("GET",b,a)}});test("When statistics is selected on the subnavigator, the router navigates to the statistics url",function(){var a=this.sandbox.spy(this.router,"goToStatistics");this.startNavigation();this.subnavigator.trigger("itemSelected",{item:{id:"statistics"}});sinon.assert.called(a)});test("When activity is selected on the subnavigator, the router navigates to the activity url",function(){var a=this.sandbox.spy(this.router,"goToActivity");this.startNavigation();this.subnavigator.trigger("itemSelected",{item:{id:"activity"}});sinon.assert.called(a)});test("When the navigation is started, the subnavigator is displayed",function(){var a=this.sandbox.spy(this.subnavigator,"show");this.startNavigation();sinon.assert.called(a)});test("When the router navigates to the statistics url, the content for the statistics view is fetched from the server and rendered on the page",function(){this.serverReturnsHtmlForStatisticsPage("statistics-html");this.startNavigation();this.router.trigger("statistics");this.server.respond();equal(this.el.html(),"statistics-html")});test("When the router navigates to the statistics url, the subnavigator is told to display the statistics option",function(){this.serverReturnsHtmlForStatisticsPage("any-html");var a=this.sandbox.spy(this.subnavigator,"selectItem");this.startNavigation();this.router.trigger("statistics");this.server.respond();sinon.assert.calledOnce(a);sinon.assert.calledWith(a,"statistics")});test("When the router navigates to the statistics url an error is displayed if the server can not be contacted",function(){this.serverReturnsErrorForStatisticsPage();this.sandbox.stub(JIRA.Messages,"showErrorMsg");this.startNavigation();this.router.trigger("statistics");this.server.respond();equal(JIRA.Messages.showErrorMsg.callCount,1)});test("When the router navigates to the activity url, the content for the activity view is fetched from the server and rendered on the page",function(){this.serverReturnsHtmlForActivityPage("activity-html");this.startNavigation();this.router.trigger("activity");this.server.respond();equal(this.el.html(),"activity-html")});test("When the router navigates to the activity url, the subnavigator is told to display the activity option",function(){this.serverReturnsHtmlForActivityPage("any-html");var a=this.sandbox.spy(this.subnavigator,"selectItem");this.startNavigation();this.router.trigger("activity");this.server.respond();sinon.assert.calledOnce(a);sinon.assert.calledWith(a,"activity")});test("When the router navigates to the activity url an error is displayed if the server can not be contacted",function(){this.serverReturnsErrorForActivityPage();this.sandbox.stub(JIRA.Messages,"showErrorMsg");this.startNavigation();this.router.trigger("activity");this.server.respond();equal(JIRA.Messages.showErrorMsg.callCount,1)});test("When the content of the page is updated, an event is triggered",function(){this.serverReturnsHtmlForActivityPage("any-html");var a=this.spy(this.navigation,"trigger");this.startNavigation();this.router.trigger("activity");this.server.respond();sinon.assert.calledWith(a,"pageRefreshed")});test("When the statistics page is selected, an event is triggered",function(){var a=this.spy(this.navigation,"trigger");this.startNavigation();this.router.trigger("statistics");sinon.assert.calledWith(a,"statisticsPageSelected")});test("When the activity page is selected, an event is triggered",function(){var a=this.spy(this.navigation,"trigger");this.startNavigation();this.router.trigger("activity");sinon.assert.calledWith(a,"activityPageSelected")})});