(function () {
    "use strict";
    
    var triggerAnalyticsEventWithName = function(name) {
        AJS.trigger("analyticsEvent", {
            name: name
        });
    };

    var NavigationAnalytics = function () {
        return {
            start: function (navigation) {
                navigation.on({
                    "statisticsPageSelected": function () {
                        triggerAnalyticsEventWithName("jira.projects.summary.page.issue.statistics.selected");
                    },
                    "activityPageSelected": function () {
                        triggerAnalyticsEventWithName("jira.projects.summary.page.activity.stream.selected");
                    }
                });
            }
        };
    };
    
    AJS.namespace("JIRA.Projects.Summary.NavigationAnalytics");
    JIRA.Projects.Summary.NavigationAnalytics.create = function () {
        return new NavigationAnalytics();
    };
}());
