AJS.test.require("com.atlassian.jira.jira-projects-plugin:summary-page-navigation-test", function() {
    "use strict";

    module("JIRA.Projects.Summary.NavigationAnalytics", {
        setup: function() {
            this.navigation = _.extend({}, Backbone.Events);
            this.navigationAnalytics = JIRA.Projects.Summary.NavigationAnalytics.create();

            this.navigationAnalytics.start(this.navigation);
        }
    });

    test("When the statistics page is selected, an analytics event is triggered", function() {
        this.spy(AJS, "trigger");

        this.navigation.trigger("statisticsPageSelected");

        sinon.assert.calledWith(AJS.trigger, "analyticsEvent", { name: "jira.projects.summary.page.issue.statistics.selected" });
    });
    
    test("When the activity page is selected, an analytics event is triggered", function() {
        this.spy(AJS, "trigger");

        this.navigation.trigger("activityPageSelected");

        sinon.assert.calledWith(AJS.trigger, "analyticsEvent", { name: "jira.projects.summary.page.activity.stream.selected" });
    });
});
