(function($) {
    "use strict";

    $(function() {
        var router = JIRA.Projects.Summary.Router.create();

        var subnavigator = JIRA.Projects.Summary.Subnavigator.create($("#summary-subnav-trigger"), $("#summary-subnav-opts"), $("#summary-subnav-title"));

        var projectKey = encodeURIComponent(JIRA.API.Projects.getCurrentProjectKey());
        var transformedUrl = router.getTransformedUrlForNonPushStateBrowser(projectKey);
        if (transformedUrl) {
            var Browser = require("jira/projects/util/browser");
            Browser.locationReplace(transformedUrl);
            return;
        }

        var navigationAnalytics = JIRA.Projects.Summary.NavigationAnalytics.create();
        var navigation = JIRA.Projects.Summary.Navigation.create();

        var issueVignetteNavigation = require("jira/projects/page/summary/issue/vignettes/navigation");
        var issueVignetteAnalytics = require("jira/projects/page/summary/issue/vignettes/analytics");
        var vignetteSwitcher = require("jira/projects/page/summary/issue/vignettes/switcher");
        var vignettes = require("jira/projects/page/summary/issue/vignettes/manager");
        var lastViewedVignetteUpdater = require("jira/projects/page/summary/issue/vignettes/lastviewed/manager");

        var statisticsLink = require("jira/projects/page/summary/navigation/gotostatistics");

        issueVignetteAnalytics.startAnalyticsForGoToStatisticsLink(statisticsLink);
        issueVignetteAnalytics.startAnalyticsForVignetteNavigation(issueVignetteNavigation);
        issueVignetteAnalytics.startAnalyticsForVignettes(vignettes);

        navigationAnalytics.start(navigation);
        navigation.start($("#summary-body"), subnavigator, router);
        navigation.on("pageRefreshed", function () {
            vignettes.start();
            statisticsLink.start($("#statistics-link"), router);
            var switcher = vignetteSwitcher.start($("#vignette-switcher-trigger"), $("#vignette-switcher-opts"), $("#vignette-switcher-title"));
            issueVignetteNavigation.start(switcher, vignettes, lastViewedVignetteUpdater);
        });

        Backbone.history.start({
            pushState: true,
            root: AJS.contextPath() + "/projects/" + projectKey + "/summary"
        });
    });
}(AJS.$));
