define("jira/projects/page/summary/issue/vignettes/switcher", [
    "backbone",
    "underscore"
], function(
    Backbone,
    _
) {
    "use strict";

    return _.extend({
        clickItem: function(itemId, extraData) {
            if (this.subnavigator) {
                this.subnavigator.trigger("itemSelected", _.extend({
                    item: {
                        id: itemId
                    }
                }, extraData));
                this.subnavigator.selectItem(itemId);
                this.subnavigator.show();
            }
        },

        show: function() {
            this.subnavigator.show();
        },

        start: function(triggerPlaceholder, contentPlaceholder, titlePlaceholder) {
            this.subnavigator = new JIRA.Projects.Subnavigator({
                id: "vignette-switcher",
                triggerPlaceholder: triggerPlaceholder,
                contentPlaceholder: contentPlaceholder,
                titlePlaceholder: titlePlaceholder,
                itemGroups: [{
                    id: "priority",
                    label: AJS.I18n.getText("project.page.summary.prioritysummary.title")
                }, {
                    id: "assignee",
                    label: AJS.I18n.getText("project.page.summary.assigneesummary.title")
                }],
                selectedItem: "priority",
                hideSelectedItem: false,
                changeViewText: AJS.I18n.getText("project.page.summary.issue.summary.vignette.switcher")
            });

            this.subnavigator.on("itemSelected", _.bind(function(event) {
                this.trigger("itemSelected", event);
            }, this));

            return this;
        }
    }, Backbone.Events);
});
