AJS.test.require("com.atlassian.jira.jira-projects-plugin:summary-page-issue-vignettes-navigation-test", function() {
    "use strict";

    require([
        "jquery"
    ], function(
        $
    ) {
        module("jira/projects/page/summary/issue/vignettes/switcher", {
            setup: function() {
                this.sandbox = sinon.sandbox.create();

                var switcher = require("jira/projects/page/summary/issue/vignettes/switcher");
                this.switcher = switcher.start($("<div />"), $("<div />"), $("<div />"));
            },

            teardown: function() {
                this.sandbox.restore();
            }
        });

        test("When an item is clicked, an 'itemSelected' event is triggered", function() {
            this.spy(this.switcher, "trigger");

            this.switcher.clickItem("switcherItem");

            sinon.assert.calledOnce(this.switcher.trigger);
            sinon.assert.calledWith(this.switcher.trigger, "itemSelected", {
                item: { id: "switcherItem" }
            });
        });
    });
});
