AJS.test.require("com.atlassian.jira.jira-projects-plugin:summary-page-summary-bar-resources-test", function() {
    "use strict";

    require([
        "jira/projects/util/browser",
        "jquery"
    ], function(
        Browser,
        $
    ) {
        module("jira/projects/page/summary/issue/vignettes/statussummary", {
            setup: function() {
                this.statusSummary = require("jira/projects/page/summary/issue/vignettes/statussummary");
                this.page = $("#qunit-fixture");
            },

            createLinkWithCategory: function(category) {
                return this.attachLinkToPage("<a class='status-category-link' data-status-category-key='" + category + "'></a>");
            },

            createLinkWithUrl: function(url) {
                return this.attachLinkToPage("<a class='status-category-link' href='" + url + "'></a>");
            },

            attachLinkToPage: function(linkHtml) {
                var statusSummaryElement = $(
                    "<div id='status-summary-bar-links'>" +
                    linkHtml +
                    "</div>"
                );
                this.page.append(statusSummaryElement);
                return statusSummaryElement.find("a");
            },

            stubRedirections: function() {
                return this.stub(Browser, "locationAssign");
            }
        });

        test("When a status link is clicked, a 'statusLinkClicked' event is triggered with the expected data", function() {
            this.stubRedirections();
            this.spy(this.statusSummary, "trigger");

            var expectedStatusCategory = "some-category";
            var statusLink = this.createLinkWithCategory(expectedStatusCategory);

            this.statusSummary.start();
            statusLink.click();

            sinon.assert.calledWith(this.statusSummary.trigger, "statusLinkClicked", {
                statusCategory: expectedStatusCategory
            });
        });

        test("When a status link is clicked, we navigate to the expected page", function() {
            var redirections = this.stubRedirections();

            var expectedUrl= "some-url";
            var statusLink = this.createLinkWithUrl(expectedUrl);

            this.statusSummary.start();
            statusLink.click();

            sinon.assert.calledWith(redirections, expectedUrl);
        });

        test("When getting all the event names for the vignette, we return the expected event names", function() {
            var expectedEvents = ["statusLinkClicked", "statusDialogShown"];
            expectedEvents.sort();

            var eventNames = this.statusSummary.getEventNames();
            eventNames.sort();

            deepEqual(eventNames, expectedEvents);
        });
    });
});
