AJS.test.require("com.atlassian.jira.jira-projects-plugin:summary-page-priority-summary-test-resources", function() {
    "use strict";

    require([
        "jira/projects/util/browser",
        "backbone",
        "underscore",
        "jquery"
    ], function(
        Browser,
        Backbone,
        _,
        $
    ) {
        module("jira/projects/page/summary/issue/vignettes/prioritysummary", {
            setup: function() {
                this.prioritySummary = require("jira/projects/page/summary/issue/vignettes/prioritysummary");
                this.page = $("#qunit-fixture");
            },
            stubRedirections: function() {
                return this.stub(Browser, "locationAssign");
            },
            attachLinkToPage: function(linkAttributes) {
                var link = $(
                    "<a class='priority-link' "
                    + linkAttributes
                    + "></a>"
                );
                this.page.append(link);

                return link;
            },
            createLinkWithSequenceAndCount: function(sequence, count) {
                return this.attachLinkToPage("data-priority-sequence='" + sequence +
                "' data-priority-count='" + count + "'");
            },
            createLinkWithHref: function(href) {
                return this.attachLinkToPage("href='" + href + "'");
            }
        });

        test("When a priority link is clicked, a 'priorityLinkClicked' event is triggered with the correct data", function() {
            this.stubRedirections();
            this.spy(this.prioritySummary, "trigger");
            var expectedClickEventData = {
                prioritySequence: "3",
                priorityCount: "4"
            };
            var priorityLink = this.createLinkWithSequenceAndCount(3, 4);

            this.prioritySummary.start();
            priorityLink.click();

            sinon.assert.calledWith(this.prioritySummary.trigger, "priorityLinkClicked", expectedClickEventData);
        });

        test("When a priority link is clicked, we navigate to the expected page", function() {
            var redirections = this.stubRedirections();
            var expectedUrl = "/some/url";
            var priorityLink = this.createLinkWithHref(expectedUrl);

            this.prioritySummary.start();
            priorityLink.click();

            sinon.assert.calledWith(redirections, expectedUrl);
        });

        test("When getting all the event names for the vignette, we return the expected event names", function() {
            var expectedEvents = ["priorityLinkClicked", "priorityDialogShown"];
            expectedEvents.sort();

            var eventNames = this.prioritySummary.getEventNames();
            eventNames.sort();

            deepEqual(eventNames, expectedEvents);
        });
    });
});
