define("jira/projects/page/summary/issue/vignettes/navigation", [
    "underscore",
    "backbone"
], function(
    _,
    Backbone
) {
    "use strict";

    var clickLastViewedItemInSwitcher = function(switcher, lastViewedId) {
        switcher.clickItem(lastViewedId, { isLastViewedLoad: true });
    };

    return _.extend({
        start: function(switcher, vignetteManager, lastViewedVignetteUpdater) {
            switcher.off("itemSelected").on("itemSelected", _.bind(function (event) {
                var selectedVignetteId = event.item.id;
                vignetteManager.showVignetteWithId(selectedVignetteId);

                lastViewedVignetteUpdater.updateLastViewedVignette(selectedVignetteId);

                if (!event.isLastViewedLoad) {
                    this.trigger("vignetteSelected", {
                        selectedItem: selectedVignetteId
                    });
                }
            }, this));

            switcher.show();

            lastViewedVignetteUpdater.getLastViewedVignette()
                .done(function (data) {
                    var lastViewedVignetteId = data.value.id;
                    clickLastViewedItemInSwitcher(switcher, lastViewedVignetteId);
                })
                .fail(function (error) {
                    clickLastViewedItemInSwitcher(switcher, vignetteManager.getDefaultSwitchableVignetteId());
                });
        }
    }, Backbone.Events);
});
