define("jira/projects/page/summary/issue/vignettes/lastviewed/manager", [
    "jquery"
], function(
    $
) {
    "use strict";

    var propertyUpdateUrl = AJS.contextPath()
                    + "/rest/api/2/user/properties/lastViewedVignette?username="
                    + JIRA.Users.LoggedInUser.userName();

    var lastViewedVignetteRequest = function(method, data) {
        return $.ajax({
            contentType: "application/json",
            data: JSON.stringify(data),
            type: method,
            url: propertyUpdateUrl
        });
    };

    return {
        updateLastViewedVignette: function(vignetteId) {
            lastViewedVignetteRequest("PUT", { id: vignetteId });
        },

        getLastViewedVignette: function() {
            return lastViewedVignetteRequest("GET");
        }
    };
});
