AJS.test.require("com.atlassian.jira.jira-projects-plugin:summary-page-issue-vignettes-last-viewed-vignette-manager-test-resources", function() {
    "use strict";

    require([
        "jquery"
    ], function(
        $
    ) {
        module("jira/projects/page/summary/issue/vignettes/lastviewed/manager", {
            setup: function() {
                this.lastViewedUpdater = require("jira/projects/page/summary/issue/vignettes/lastviewed/manager");

                this.propertyUpdateUrl = AJS.contextPath()
                    + "/rest/api/2/user/properties/lastViewedVignette?username="
                    + JIRA.Users.LoggedInUser.userName();
            },

            requestObjectWithMethodAndData: function(method, data) {
                return {
                    contentType: "application/json",
                    data: JSON.stringify(data),
                    type: method,
                    url: this.propertyUpdateUrl
                };
            }
        });

        test("When updating the last viewed vignette, the correct ajax call is made", function() {
            this.stub($, "ajax");
            var vignetteId = "vignette-id";

            this.lastViewedUpdater.updateLastViewedVignette(vignetteId);

            sinon.assert.calledOnce($.ajax);
            sinon.assert.calledWith($.ajax, this.requestObjectWithMethodAndData("PUT", { id: vignetteId }));
        });

        test("When getting the last viewed vignette, the correct ajax call is made", function() {
            this.stub($, "ajax");

            this.lastViewedUpdater.getLastViewedVignette();

            sinon.assert.calledOnce($.ajax);
            sinon.assert.calledWith($.ajax, this.requestObjectWithMethodAndData("GET"));
        });
    });
});
