define("jira/projects/page/summary/issue/vignettes/assigneesummary", [
    "jira/projects/util/browser",
    "jquery",
    "underscore",
    "backbone"
], function(
    Browser,
    $,
    _,
    Backbone
) {
    "use strict";

    var events = {
        dialogShown: "assigneeDialogShown",
        linkClicked: "assigneeLinkClicked"
    };

    var registerClickEventForAssigneeLinks = function(assigneeSummary) {
        $(".assignee-link").click(function(clickEvent) {
            clickEvent.preventDefault();
            var userName = clickEvent.target.getAttribute("rel");
            assigneeSummary.trigger(events.linkClicked, {
                isUnassigned: userName === null
            });

            var linkDestination = clickEvent.target.getAttribute("href");
            Browser.locationAssign(linkDestination);
        });
    };

    var createAssigneeDialog = function(assigneeSummary) {
        var dialogTriggerEl = $("a#show-all-assignees").get(0);
        var assigneeBreakdownDialog = AJS.InlineDialog(dialogTriggerEl, "assignees-dialog", function (content, trigger, showPopup) {

            var assigneeList = JSON.parse(dialogTriggerEl.getAttribute("data-assignee-counts"));

            content.html(JIRA.Project.Summary.Issue.Vignette.Templates.assigneeDialog({
                assigneeList: assigneeList
            }));
            showPopup();
            registerClickEventForAssigneeLinks(assigneeSummary);
            return false;
        }, {
            onHover: true,
            width: 350,
            initCallback: function() {
                assigneeSummary.trigger(events.dialogShown);
            }
        });

        assigneeBreakdownDialog.addClass("breakdown-dialog");
    };

    return _.extend({
        getEventNames: function() {
            return Object.keys(events).map(function(key) {
                return events[key];
            });
        },

        getId: function() {
            return "assignee";
        },

        show: function() {
            $(".assignee-vignette").removeClass("hidden");
        },

        hide: function() {
            $(".assignee-vignette").addClass("hidden");
        },

        start: function() {
            createAssigneeDialog(this);
            registerClickEventForAssigneeLinks(this);
        }
    }, Backbone.Events);
});
