(function($) {
    "use strict";

    function emitAnalyticsEvent(reportId, initialLoad) {
        AJS.trigger('analyticsEvent', {
            name: "jira.project.sidebar.report.select",
            data: {
                reportId: reportId,
                initialLoad: initialLoad
            }
        });
    }

    $(function() {
        var triggerPlaceholder = $("#reports-subnav-trigger");
        var contentPlaceholder = $("#reports-subnav-opts");
        var titlePlaceholder = $("#reports-subnav-title");
        var agileReports = _.map(WRM.data.claim("agile-reports"), function(report) {
            return {
                id: report.key,
                label: report.label,
                description: report.description,
                link: AJS.contextPath() + report.url
            };
        });

        var subnavigator = new JIRA.Projects.Subnavigator({
            id: "reports",
            triggerPlaceholder: triggerPlaceholder,
            contentPlaceholder: contentPlaceholder,
            itemGroups: [agileReports, [{
                id: "com.atlassian.jira.jira-projects-plugin:report-page",
                label: AJS.I18n.getText("project.page.report.subnavigator.item.all.label"),
                description: AJS.I18n.getText("project.page.report.subnavigator.item.all.description")
            }]],
            selectedItem: "com.atlassian.jira.jira-projects-plugin:report-page",
            titlePlaceholder: titlePlaceholder,
            hideSelectedItem: true,
            changeViewText: AJS.I18n.getText("project.page.report.subnavigator.change.view")
        });
        subnavigator.on('itemSelected', function(e) {
            emitAnalyticsEvent(e.item.id, false);
        });

        subnavigator.show();

        emitAnalyticsEvent('com.atlassian.jira.jira-projects-plugin:report-page', true);

        JIRA.API.getSidebar().done(function() {
            JIRA.Projects.Sidebar.Reports.storeLastViewedReportLink(window.location.href);
        });
    });

}(AJS.$));
