(function reportsPageAnalytics($) {
    "use strict";

    AJS.namespace("JIRA.Projects.Report");

    JIRA.Projects.Report.Analytics = function() {

        $('.reports .reports__list__report').on('click', function(e) {
            var $this = $(this);

            AJS.trigger('analyticsEvent', {
                name: "jira.projects.report.clicked",
                data: {
                    report: $this.attr("data-report-key"),
                    category: $this.closest('ul').attr("data-category-key"),
                    listPosition: $this.closest('li').prevAll().length + 1
                }
            });
        });
    };

    $(JIRA.Projects.Report.Analytics);
}(AJS.$));