AJS.test.require(['com.atlassian.jira.jira-projects-plugin:report-page-assets'], function(){
    "use strict";

    var $ = AJS.$;
    module('JIRA.Projects.Report.Analytics', {
        setup: function() {
            this.$reports = $(
                '<div class="reports">' +
                '	<h2 class="reports__category">Agile</h2>' +
                '	<ul class="reports__list" data-category-key="agile">' +
                '		<li class="reports__list__item">' +
                '			<a href="#agile" class="reports__list__report" data-report-key="key:agile">agile report</a>' +
                '		</li>' +
                '	</ul>' +
                '	<h2 class="reports__category">Other</h2>' +
                '	<ul class="reports__list" data-category-key="other">' +
                '		<li class="reports__list__item">' +
                '			<a href="#other" class="reports__list__report" data-report-key="key:other">other report</a>' +
                '		</li>' +
                '		<li class="reports__list__item">' +
                '			<a href="#other2" class="reports__list__report" data-report-key="key:other2">other report 2</a>' +
                '		</li>' +
                '	</ul>' +
                '</div>'
            );

            $('#qunit-fixture').append(this.$reports);
            JIRA.Projects.Report.Analytics();

            sinon.spy(AJS, 'trigger');
        },
        teardown: function() {
            AJS.trigger.restore();
        }
    });

    test('Attaches analytics events to all report links and triggers them with right parameters on click', function () {
        this.$reports.find('.reports__list__report').click();

        ok(AJS.trigger.calledThrice);


        function assertAnalyticsTriggeredWith(callNumber, data) {
            var args = AJS.trigger.getCall(callNumber).args;
            equal(args[0], 'analyticsEvent');
            equal(args[1].name, "jira.projects.report.clicked");
            deepEqual(args[1].data, data);
        }

        assertAnalyticsTriggeredWith(0, {
            report: "key:agile",
            category: "agile",
            listPosition: 1
        });
        assertAnalyticsTriggeredWith(1, {
            report: "key:other",
            category: "other",
            listPosition: 1
        });
        assertAnalyticsTriggeredWith(2, {
            report: "key:other2",
            category: "other",
            listPosition: 2
        });
    });

});

