define("jira/projects/page/release/release-page-data", [
    "jquery",
    "jira/api/projects",
    "jira/featureflags/feature-manager",
    "jira/ajs/ajax/smart-ajax",
    "wrm/data",
    "wrm/context-path"
], function(
    $,
    Projects,
    FeatureManager,
    SmartAjax,
    WRMData,
    contextPath
) {
    "use strict";

    var releasePageData = new $.Deferred();

    if (!FeatureManager.isFeatureEnabled("jira.sidebar.components.inlineversions")) {
        $.ajax({
            type: 'GET',
            url: contextPath() + '/rest/projects/1.0/project/' + Projects.getCurrentProjectKey() + '/release/allversions',
            contentType: "application/json",
            timeout: 120000
        }).then(function(response) {
            releasePageData.resolve(response);
        }).fail(function(xhr) {
            releasePageData.reject(SmartAjax.buildSimpleErrorContent(xhr))
        });
    } else {
        try {
            releasePageData.resolve(WRMData.claim('com.atlassian.jira.projects.page.release:versions'));
        } catch(e) {
            releasePageData.reject(AJS.I18n.getText("project.page.release.error.loading"));
        }
    }

    return releasePageData.promise();
});
