(function($) {
    "use strict";

    function isCurrentlyViewingSidebarProjectPage() {
        return JIRA.API && JIRA.API.Projects && JIRA.API.Projects.getCurrentProjectKey && JIRA.API.Projects.getCurrentProjectKey() !== undefined;
    }

    $(function() {
        if(isCurrentlyViewingSidebarProjectPage()) {
            var triggerPlaceholder = $("#version-subnav-trigger");
            var contentPlaceholder = $("#version-subnav-content");
            var titlePlaceholder = $("#version-subnav-header");
            var allVersions = _.map(WRM.data.claim("com.atlassian.jira.project.browse.version:versions"), function (versionView) {
                return {
                    id: versionView.id,
                    label: versionView.name,
                    description: versionView.description,
                    link: versionView.url
                };
            });
            var selectedVersionId = WRM.data.claim("com.atlassian.jira.project.browse.version:selectedVersionId");

            var subnavigator = new JIRA.Projects.Subnavigator({
                id: "versions",
                triggerPlaceholder: triggerPlaceholder,
                contentPlaceholder: contentPlaceholder,
                titlePlaceholder: titlePlaceholder,
                itemGroups: [allVersions, [{
                    id: "com.atlassian.jira.jira-projects-plugin:release-page",
                    label: AJS.I18n.getText("project.page.release.subnavigator.item.all"),
                    description: AJS.I18n.getText("project.page.release.subnavigator.item.all.description"),
                    link: AJS.contextPath() + "/projects/" + JIRA.API.Projects.getCurrentProjectKey() + "?selectedItem=com.atlassian.jira.jira-projects-plugin:release-page"
                }]],
                selectedItem: selectedVersionId,
                changeViewText: AJS.I18n.getText("project.page.release.subnavigator.change.release"),
                hideSelectedItem: false
            });

            subnavigator.show();
        }
    });
}(AJS.$));
