define("jira/projects/release/version-adapter", [
    "backbone",
    "jquery",
    "jira/projects/abstract-model/submit-model-states",
    "jira/ajs/ajax/ajax-util"
], function (
    Backbone,
    $,
    SubmitModelStates,
    ajaxUtil
) {
    "use strict";

    // Adapter for the model that being used in Version Dialogs
    var VersionAdapter = function(model) {
        this._backboneModel = model;
        this.model = this;
    };

    VersionAdapter.prototype.getUnresolvedIssueCount = function(options) {
        this._backboneModel.getUnresolvedIssueCount(options);
        return this;
    };

    VersionAdapter.prototype.getMoveVersionsJSON = function() {
        return this._backboneModel.getMoveVersionsJSON();
    };
    VersionAdapter.prototype.toJSON = function() {
        return this._backboneModel.toJSON();
    };
    VersionAdapter.prototype.get = function(key) {
        // Version dialog expects to see releaseDate as a 'string'
        // Current model returns an object: {"formatted": "03/oct/16", "iso": "2016-10-03"}
        // we're decorating the get method to handle the conversion
        if (key === 'releaseDate') {
            var releaseDate = this._backboneModel.get('releaseDate');
            if (releaseDate) {
                return releaseDate.iso;
            }
            return undefined;
        }
        return this._backboneModel.get(key);
    };

    VersionAdapter.prototype.save = function(attributes, options) {
        this._backboneModel.lastSaveAttributes = _.clone(attributes);
        options = options || {};
        var error = options.error;
        var success = options.success;

        var deferred = $.Deferred();

        Backbone.Model.prototype.save.call(this._backboneModel, [], {
            attrs: attributes
        }).done(function (xhr) {
                deferred.resolve();
                this._backboneModel.set("state", SubmitModelStates.SUCCESSFUL);
                this._backboneModel.addStateTimeout(SubmitModelStates.SUCCESSFUL, SubmitModelStates.READY);
                if (success) {
                    success.call(this, this, xhr);
                }
            }.bind(this))
            .fail(function (xhr) {
                deferred.reject(xhr);
                if(xhr.status != 400) {
                    this.set("state", SubmitModelStates.ERROR_UPDATE);
                }
                this.set("errorMsg", AJS.escapeHtml(ajaxUtil.getErrorMessageFromXHR(xhr)));
                if( error ) {
                    var data = $.parseJSON(xhr.responseText || xhr.data);
                    error.call(this, this, data, xhr);
                }
            }.bind(this._backboneModel));

        return deferred;
    };

    VersionAdapter.prototype.render = function() {
        this._backboneModel.detailsSync();
    };

    return VersionAdapter;
});