AJS.test.require(['com.atlassian.jira.jira-projects-plugin:release-page-assets'], function () {
    "use strict";

    var Backbone = require("backbone");
    var $ = require("jquery");

    module('SubmitModel', {
        setup: function () {
            this.context = AJS.test.mockableModuleContext();
            this.sandbox = sinon.sandbox.create();
            this.mockModules();
            this.sandbox.useFakeServer();

            this.SubmitModel = this.context.require("jira/projects/release/submit-model");
            this.xhr = {};
        },
        teardown: function () {
            this.sandbox.restore();
        },
        mockModules: function() {
            this.SmartAjax = {};
            this.context.mock("jira/ajs/ajax/smart-ajax", this.SmartAjax);
        }
    });

    test("parse should produce valid SubmitModel", function () {
        var addResponse = {
            "self": "http://localhost:2990/jira/rest/api/2/version/10500",
            "id": "10500",
            "description": "test desc",
            "name": "test",
            "archived": false,
            "released": false,
            "startDate": "2016-04-01",
            "releaseDate": "2016-10-03",
            "overdue": false,
            "userStartDate": "01/apr/16",
            "userReleaseDate": "03/oct/16",
            "projectId": 10000
        };

        var parseExpected = {
            "self": "http://localhost:2990/jira/rest/api/2/version/10500",
            "id": "10500",
            "description": "test desc",
            "name": "test",
            "archived": false,
            "released": false,
            "startDate": {"formatted": "01/apr/16", "iso": "2016-04-01"},
            "releaseDate": {"formatted": "03/oct/16", "iso": "2016-10-03"},
            "overdue": false,
            "projectId": 10000,
            "status": {
                "unmapped": {
                    "count": 0,
                    "jqlUrl": ""
                },
                "toDo": {
                    "count": 0,
                    "jqlUrl": ""
                },
                "inProgress": {
                    "count": 0,
                    "jqlUrl": ""
                },
                "complete": {
                    "count": 0,
                    "jqlUrl": ""
                }
            }
        };

        var submitModel = new this.SubmitModel();

        var parseResponse = submitModel.parse(addResponse, {});

        deepEqual(parseResponse, parseExpected);
    });

    test("test getUnresolvedIssueCount()", function () {
        var submitModel = new this.SubmitModel();
        this.SmartAjax.makeRequest = function(options) {
            options.complete({}, 200, {successful: true})
        };
        var options = {
            success: this.spy()
        };
        var unresolvedIssueCount = submitModel.getUnresolvedIssueCount(options);
        sinon.assert.calledOnce(options.success);
    });

    test("test getMoveVersionsJSON()", function () {
        var VersionCollection = Backbone.Collection.extend({
            model: this.SubmitModel
        });
        var versionCollection = new VersionCollection();

        var versionModel1 = new this.SubmitModel({ name: 'version 1', nextScheduled: false});
        versionCollection.add(versionModel1);
        var versionModel2 = new this.SubmitModel({ name: 'version 2'});
        versionCollection.add(versionModel2);
        var versionModel3 = new this.SubmitModel({ name: 'version 3', released : true });
        versionCollection.add(versionModel3);

        var versionToMove = versionModel2.getMoveVersionsJSON();

        var expected = new this.SubmitModel({ name: 'version 1', nextScheduled: true});
        deepEqual(versionToMove, [ expected.toJSON() ]);
    });
});

