AJS.test.require(["com.atlassian.jira.jira-projects-plugin:release-page-assets"],function(){var d=require("jira/projects/libs/marionette");var c=require("backbone");var a=require("jquery");var b=require("jira/projects/abstract-model/submit-model-states");module("SubmitController",{setup:function(){this.context=AJS.test.mockableModuleContext();this.sandbox=sinon.sandbox.create();this.sandbox.useFakeServer();this.clock=sinon.useFakeTimers();this.modelSave=a.Deferred();this.modelDetails=a.Deferred();this.sandbox.stub(c.Model.prototype,"save").returns(this.modelSave);c.Model.prototype.detailsSync=this.sandbox.stub().returns(this.modelDetails);this.pageableItems={addElement:this.sandbox.stub()};this.featureManager={isFeatureEnabled:this.sandbox.stub()};this.flags={showErrorMsg:this.sandbox.stub()};this.context.mock("jira/featureflags/feature-manager",this.featureManager);this.context.mock("jira/projects/release/submit-view",d.ItemView);this.context.mock("jira/projects/release/submit-model",c.Model);this.context.mock("jira/flag",this.flags);this.context.mock("jira/ajs/ajax/ajax-util",this.mockAjaxUtil());this.wrmData={claim:sinon.stub()};this.context.mock("wrm/data",this.wrmData);this.wrmData.claim.withArgs("com.atlassian.jira.projects.page.release:projectAdmin").returns(true);this.submitController=this.context.require("jira/projects/release/submit-controller")},teardown:function(){this.sandbox.restore()},mockAjaxUtil:function(){return{getErrorMessageFromXHR:function(){return""}}},newSubmitView:function(){return new this.submitController({pageableItems:this.pageableItems})},mockedModel:function(){return new c.Model()}});test("SubmitView should be displayed if flag is enabled and user is admin",function(){this.featureManager.isFeatureEnabled.withArgs("jira.sidebar.components.manageversions").returns(true);var e=new this.submitController({isProjectAdmin:true});ok(e.displaySubmitView())});test("SubmitView should be hidden if flag is disabled",function(){this.featureManager.isFeatureEnabled.withArgs("jira.sidebar.components.manageversions").returns(false);var e=new this.submitController({isProjectAdmin:true});ok(!e.displaySubmitView())});test("SubmitView should be hidden if user is not admin",function(){this.featureManager.isFeatureEnabled.withArgs("jira.sidebar.components.managecomponents").returns(true);var e=new this.submitController({isProjectAdmin:false});ok(!e.displaySubmitView())});test("New element is added to pageableItems on view save event",function(){var f=this.newSubmitView();var e=f.showView();e.trigger("save",this.mockedModel());ok(this.pageableItems.addElement.calledOnce)});test("versionAdded should trigger change model state to SubmitModelStates.READY from SubmitModelStates.SUCCESSFUL",function(){var f=this.newSubmitView();var e=f.versionAdd(this.mockedModel());equal(e.get("state"),b.IN_PROGRESS);this.modelSave.resolve();e.set("state",b.SUCCESSFUL);this.modelDetails.resolve();this.clock.tick(6000);equal(e.get("state"),b.READY)});test("versionAdded should NOT trigger change model state to SubmitModelStates.READY from other state than SubmitModelStates.SUCCESSFUL",function(){var f=this.newSubmitView();var e=f.versionAdd(this.mockedModel());equal(e.get("state"),b.IN_PROGRESS);this.modelSave.resolve();this.modelDetails.resolve();this.clock.tick(500);e.set("state",b.ERROR_DELETE);this.clock.tick(6000);equal(e.get("state"),b.ERROR_DELETE)})});