define("jira/projects/release/pageable-versions-collection", [
    "backbone",
    "jira/projects/release/submit-model",
    "jira/projects/abstract-list/lazy-loading-collection"
], function (
    Backbone,
    SubmitModel,
    LazyLoadingCollection
) {
    var SubmitModelCollection = Backbone.Collection.extend({
        model: SubmitModel
    });

    var PageableVersionsCollection = LazyLoadingCollection.extend({
        collectionClass: SubmitModelCollection,


        initialize: function initialize(items) {
            LazyLoadingCollection.prototype.initialize.apply(this, arguments);
            this.listenTo(this, "added", function (model) {
                this._addToTop(this, model);
                this._addToTop(this.originalCollection, model);
                this._addToTop(this.fullCollection, model);
            });

            this.listenTo(this, "reorder", function(sourceModel, refModel) {
                this._moveBefore(this, sourceModel, refModel);
                this._moveBefore(this.originalCollection, sourceModel, refModel);
                this._moveBefore(this.fullCollection, sourceModel, refModel);

                this.trigger("collectionChanged");
            });
        },

        _addToTop: function (collection, model) {
            var idx = collection.indexOf(model);
            if (idx > 0) {
                collection.remove(model);
                collection.add(model, {at: 0});
            }
        },

        _moveBefore: function(collection, sourceModel, refModel) {
            collection.remove(sourceModel, {
                silent: true
            });
            collection.add(sourceModel, refModel && { at: collection.indexOf(refModel) });
        }

    });

    return PageableVersionsCollection;
});
