define('jira/projects/release/noversionsitemview',[
    "jira/projects/libs/marionette",
    "jira/projects/release/analytics"
], function (
    Marionette,
    Analytics
) {
    "use strict";

    var NoVersionsItemView = Marionette.ItemView.extend({
        template: JIRA.Projects.Release.Templates.noVersions,

        ui: {
            "learnMoreLink": "#learn-more"
        },
        events: {
            "click @ui.learnMoreLink": "onLearnMoreClicked"
        },

        onRender: function onRender() {
            this.unwrapTemplate();
            Analytics.emptyViewRendered();
        },

        onLearnMoreClicked: function () {
            Analytics.releaseLearnMoreClicked();
        }
    });

    return NoVersionsItemView;
});
