AJS.test.require(["com.atlassian.jira.jira-projects-plugin:release-page-assets"], function() {
    "use strict";

    var $ = require("jquery");
    var MergeView = require('jira/projects/release/merge-view');
    var FormDialog = require('jira/dialog/form-dialog');

    module('MergeView', {
        setup: function () {
            this.sandbox = sinon.sandbox.create();

            this.pageableItems = {
                originalCollection: this.sandbox.stub()
            };

            this.view = new MergeView({
                pageableItems: this.pageableItems
            });
            this.view.render();

            this.mockObjects();
        },

        mockObjects: function () {
            this.event = {
                preventDefault: sinon.stub()
            };
            this.sandbox.stub(FormDialog.prototype, "show");
            this.sandbox.stub(JIRA.Admin.Version.MergeForm.prototype, "submit");
        },

        teardown: function() {
            this.sandbox.restore();
        },
    });

    test('Should merge correct versions', function () {
        var dialog = this.view.mergeVersions(this.event);

        dialog.$form = {};
        dialog.hideFooterLoadingIndicator = sinon.stub();
        dialog.$form.serializeObject = function() {
            return {
                idsToMerge: ['1']
            };
        };
        dialog.$popup = {
            find: sinon.stub()
        };
        dialog.$popup.find.withArgs("#idsToMerge + .error").returns({
            length: 0
        });

        dialog.options.submitHandler.call(dialog, this.event, {});
        sinon.assert.notCalled(dialog.hideFooterLoadingIndicator);
    });

    test('Should prevent attempt to merge incorrect versions', function () {
        var dialog = this.view.mergeVersions(this.event);

        dialog.$form = {};
        dialog.hideFooterLoadingIndicator = sinon.stub();
        dialog.$form.serializeObject = function() {
            return {
                idsToMerge: []
            };
        };
        dialog.$popup = {
            find: sinon.stub()
        };
        dialog.$popup.find.withArgs("#idsToMerge + .error").returns({
            length: 1
        });
        dialog.$popup.find.withArgs(".aui-button:disabled").returns({
            removeAttr: sinon.stub()
        });

        dialog.options.submitHandler.call(dialog, this.event, {});
        sinon.assert.calledOnce(dialog.hideFooterLoadingIndicator);
    });
});