define("jira/projects/release/analytics", [

], function () {
    "use strict";

    var triggerEvent = function (key, data) {
        AJS.trigger('analyticsEvent', {
            name: key,
            data: data || {}
        })
    };

    return {
        progressDialogClick: function () {
            triggerEvent("jira.projects.release.progress.dialog.click");
        },
        navigate: function navigate() {
            var status = JIRA.Projects.AbstractList.NavigationUtils.getQueryStringParam("status", true) || "unreleased";
            var contains = JIRA.Projects.AbstractList.NavigationUtils.getQueryStringParam("contains", true) || "";
            var page = +JIRA.Projects.AbstractList.NavigationUtils.getQueryStringParam("page", true) || 1;

            triggerEvent("jira.projects.release.navigate", {
                status: status,
                containsLength: contains.length,
                page: page
            });
        },

        emptyViewRendered: function () {
            triggerEvent("jira.projects.release.empty.view");
        },

        releaseLearnMoreClicked: function () {
            triggerEvent("jira.projects.release.learn.more.click");
        },

        showEditVersion: function() {
            triggerEvent("jira.projects.release.edit.show");
        },

        editVersionFail: function() {
            triggerEvent("jira.projects.release.edit.fail");
        },

        editVersionSuccess: function() {
            triggerEvent("jira.projects.release.edit.success");
        }
    };
});