define("jira/projects/components/searchlayoutview", [
    "jira/projects/components/submitview",
    "jira/projects/libs/marionette",
    "jira/projects/components/tablelayoutview",
    "jira/projects/components/empty-view",
    "backbone"
], function(
    SubmitView,
    Marionette,
    TableLayoutView,
    NoComponentsItemView,
    Backbone
) {
    "use strict";

    var SearchLayoutView = Marionette.LayoutView.extend({
        template: JIRA.Projects.AbstractList.Templates.searchLayout,
        regions: {
            filterRegion: "#filter-container",
            submitRegion: "#submit-container",
            mainRegion: "#content-container"
        },

        initialize: function (options) {
            this.pageableItems = options.pageableItems;
            this.filter = options.filter;
            this.listenTo(this.pageableItems, "collectionChanged", this._rerenderMainRegion);

            this._submitController = options.submitController;
        },

        onRender: function () {
            if (this._submitController.displaySubmitView()) {
                this.submitRegion.show(this._submitController.showView());
            }
            this._rerenderMainRegion();
        },

        _rerenderMainRegion: function () {
            if (this.pageableItems.originalCollection.length === 0) {
                this.mainRegion.show(new NoComponentsItemView({
                    model: new Backbone.Model({learnMoreUrl: this.learnMoreUrl})
                }));
                this.filterRegion.empty();
                this.filter.emptyContainsField();
            } else {
                this.filterRegion.show(new JIRA.Projects.Components.FilterView({
                    model: this.filter
                }));
                this.listenTo(this, "filterChanged", function () {
                    this.filterRegion.currentView.render();
                });

                var mainTableLayoutView = new TableLayoutView({
                    submitController: this._submitController,
                    collection: this.pageableItems
                });
                this.mainRegion.show(mainTableLayoutView);

                this.mainRegion.currentView.render();
            }
        }
    });

    return SearchLayoutView;
});
