define("jira/projects/components/nocomponentslayoutview", [
    "jira/projects/components/submitview",
    "jira/projects/libs/marionette",
    "jira/projects/components/empty-view"
], function(
    SubmitView,
    Marionette,
    EmptyView
) {
    var NoComponentsLayoutView = Marionette.LayoutView.extend({
        template: JIRA.Projects.Components.Templates.noComponentsLayout,
        regions: {
            noComponents: ".no-components-container",
            submitRegion: ".submit-container"
        },

        onRender: function () {
            this._initializeViews();
        },

        initialize: function(options) {
            this._submitController = options.submitController;
        },

        _initializeViews: function () {
            this.noComponents.show(new EmptyView({
                model: new Backbone.Model({learnMoreUrl: this.options.learnMoreUrl})
            }));

            if (this._submitController.displaySubmitView()) {
                this.submitRegion.show(this._submitController.showView());
            }
        }
    });

    return NoComponentsLayoutView;
});