define("jira/projects/components/empty-view", [
    "jira/projects/components/analytics",
    "jira/projects/libs/marionette"
], function(
    Analytics,
    Marionette
) {
    "use strict";

    return Marionette.ItemView.extend({
        template: JIRA.Projects.Components.Templates.noComponents,

        ui: {
            "learnMoreLink": "#learn-more"
        },
        events: {
            "click @ui.learnMoreLink": "onLearnMoreClicked"
        },

        initialize: function () {
            Analytics.listenForCommonEvents(this);
        },

        onRender: function onRender() {
            this.unwrapTemplate();
            this.trigger("emptyViewEvent");
        },

        onLearnMoreClicked: function () {
            this.trigger("learnMoreClickEvent");
        }
    });

});