define("jira/projects/components/itemview", [
    "jira/projects/abstract-list/item-view",
    "jira/flag",
    "jira/ajs/ajax/ajax-util",
    "backbone",
    "jira/projects/libs/marionette",
    "jira/skate",
    "jquery",
    "underscore",
    "jira/projects/abstract-model/submit-model-states",
    "jira/projects/components/analytics"
], function (
    AbstractItemView,
    jiraFlag,
    ajaxUtil,
    Backbone,
    Marionette,
    skate,
    $,
    _,
    SubmitModelStates,
    Analytics
) {
    var ItemView = AbstractItemView.extend({
        template: JIRA.Projects.Components.Templates.row,

        triggers: {
            "click @ui.name": {
                event: "clickOnNameEvent",
                preventDefault: false,
                stopPropagation: false
            },
            "click @ui.issueCount": {
                event: "clickOnIssueEvent",
                preventDefault: false,
                stopPropagation: false
            },
            "click @ui.retryButton": {
                event: "clickOnRetryEvent",
                preventDefault: false,
                stopPropagation: false
            }
        },

        ui: _.extend({}, AbstractItemView.prototype.ui, {
            "deleteLink": ".deletecomponent_link",
            "assigneeType": "td.components-table__assignee div",
            "name": ".components-table__name",
            "issueCount": ".components-table__issues-count",
            "retryButton": ".operation-retry",
            "actionButtons": ".component-actions a",
            "detailsButton": ".details-button"
        }),

        modelEvents: _.extend({}, AbstractItemView.prototype.modelEvents, {
            "retry-delete": "_deleteItemRetry"
        }),

        outterEvents: {
            "click @ui.actionButtons": "_closeDropdown",
            "click @ui.deleteLink": "_delete"
        },

        initialize: function() {
            Analytics.listenForClicksOnItem(this);
        },

        onRender: function onRender() {
            this.listenToElements(this.outterEvents);

            if (this.ui.assigneeType.attr("title")) {
                this.ui.assigneeType.tooltip();
            }

            this.unwrapTemplate();
        },

        serializeData: function () {
            return _.extend({
                projectLeadName: this.options.controllerOptions.displayableProjectLead,
                isDefaultAssigneeProjectLead: this.options.controllerOptions.isDefaultAssigneeProjectLead
            }, Marionette.ItemView.prototype.serializeData.apply(this, arguments));
        },

        _delete: function(event) {
            event.preventDefault();
            this._deletePerform();
        },

        _deleteItemRetry: function () {
            this.model.set("state", SubmitModelStates.IN_PROGRESS_ERROR);
            if (this.model.lastDestroyOptions) {
                this.model.destroy(this.model.lastDestroyOptions);
            } else {
                this._deletePerform();
            }
        },

        _deletePerform: function () {
            this._showLoading();
            var detailsSync = this.model.detailsSync();
            require("jira/projects/components/app").requireProjectConfig.then(function() {
                var DeleteForm = require("jira-project-config/component/view/delete-form");
                var Utils = require("jira-project-config/utils");
                detailsSync.then(function() {
                    Utils.openDialogForRow(DeleteForm, this, "component-" + this.model.get("id") + "-delete-dialog");
                }.bind(this)).fail(function(xhr) {
                    this.model.set("state", SubmitModelStates.ERROR_DELETE);
                    this.model.set("errorMsg", ajaxUtil.getErrorMessageFromXHR(xhr));
                }.bind(this), this._hideLoading.bind(this));
            }.bind(this)).always(this._hideLoading.bind(this));
        },

        _closeDropdown: function() {
            if (this.ui.detailsButton.hasClass("active")) {
                this.ui.detailsButton.trigger('aui-button-invoke');
            }
        }
    });

    return ItemView;
});

AJS.namespace("JIRA.Projects.Components.ItemView", null, require("jira/projects/components/itemview"));