define("jira/projects/components/item-collection-view", [
    "jira/projects/abstract-list/item-collection-view",
    "jquery",
    "jira/projects/abstract-list/effects",
    "jira/projects/components/analytics"
], function(
    AbstractItemCollectionView,
    $,
    Effects,
    Analytics
) {
    "use strict";

    return AbstractItemCollectionView.extend({
        childView: JIRA.Projects.Components.ItemView,
        emptyView: JIRA.Projects.Components.EmptyItemView,
        childViewOptions: function() {
            return {
                controllerOptions: this.options.submitController.options
            }
        },

        initialize: function() {
            AbstractItemCollectionView.prototype.initialize.apply(this, arguments);
            Analytics.listenForCommonEvents(this);
        }
    });
    
});

AJS.namespace('JIRA.Projects.Components.ItemCollectionView', null, require('jira/projects/components/item-collection-view'));