require([
    "underscore",
    "jira/projects/components/analytics"
], function(
    _,
    Analytics
) {
    "use strict";

    AJS.namespace("JIRA.Projects.Components.FilterView");
    JIRA.Projects.Components.FilterView = JIRA.Projects.Libs.Marionette.ItemView.extend({
        template: JIRA.Projects.Components.Templates.filter,
        ui: {
            "form": "form",
            "contains": ".text"
        },
        events: {
            "submit @ui.form": "formSubmit",
            "input @ui.contains": "inputContains",
            "change @ui.contains": "inputContains"
        },
        initialize: function () {
            Analytics.listenForActionsOnItem(this);
        },
        formSubmit: function formSubmit(e) {
            e.preventDefault();
        },
        inputContains: _.debounce(function inputContains(e) {
            var filter = this.ui.contains.val();
            this.model.set("contains", filter);
            this.trigger("searchItemEvent");
        }, 300)
    });

});