AJS.test.require(["com.atlassian.jira.jira-projects-plugin:components-page-assets"], function(){
    "use strict";
    var Backbone = require("backbone");
    var _ = require("underscore");
    var FilterModel = require("jira/projects/components/filter-model");

    module('JIRA.Projects.Components.FilterModel', {
        setup: function () {
            sinon.stub(JIRA.Projects.AbstractList.NavigationUtils, "navigate");
            sinon.spy(JIRA.Projects.AbstractList.FilterModel.prototype, "initialize");
            this.comp1 = {
                id: 1,
                name: "First Compontent",
                description: "First Compontent description",
                componentUrl: "/jira/browse/X/component/1",
                issuesCount: 6,
                issuesUrl: "/jira/secure/IssueNavigator.jspa?reset=true&jqlQuery=project+%3D+X+AND+component+%3D+1",
                leadUserDisplayName: "admin",
                leadUserProfileLinkHtml: "admin link html"
            };
            this.comp2 = {
                id: 2,
                name: "Second Compontent",
                componentUrl: "/jira/browse/X/component/2",
                issuesCount: 2,
                issuesUrl: "/jira/secure/IssueNavigator.jspa?reset=true&jqlQuery=project+%3D+X+AND+component+%3D+2",
                leadUserDisplayName: "",
                leadUserProfileLinkHtml: ""
            };

            this.mockPageableCollection = {
                originalCollection: new Backbone.Collection([this.comp1, this.comp2]),
                resetFilter: sinon.spy()
            };

            this.filterModel = new FilterModel({
                pageableCollection: this.mockPageableCollection
            });
        },

        compareResetFilterCall: function(callNumber, expected) {
            var call = this.mockPageableCollection.resetFilter.getCall(callNumber);
            deepEqual (_.map(call.args[0], function (val) {
                return val.attributes;
            }), expected);
        },

        teardown: function () {
            JIRA.Projects.AbstractList.FilterModel.prototype.initialize.restore();
            JIRA.Projects.AbstractList.NavigationUtils.navigate.restore();
        }
    });

    test('Should call parent\'s initialize.', function () {
        sinon.assert.calledOnce(JIRA.Projects.AbstractList.FilterModel.prototype.initialize);
    });

    test('Should filter collection when adding new filter criteria.', function () {
        this.filterModel.set("contains", "nothing");
        sinon.assert.calledOnce(this.mockPageableCollection.resetFilter);
        sinon.assert.calledWith(this.mockPageableCollection.resetFilter, []);
    });

    test('Should filter collection when changing existing filter criteria.', function () {
        this.filterModel.set("contains", "text");
        this.filterModel.set("contains", "nothing");
        sinon.assert.calledTwice(this.mockPageableCollection.resetFilter);
        sinon.assert.calledWith(this.mockPageableCollection.resetFilter, []);
    });

    test('Should filter collection when removing filter criteria.', function () {
        this.filterModel.set("contains", "nothing");
        this.filterModel.unset("contains");
        sinon.assert.calledTwice(this.mockPageableCollection.resetFilter);
        this.compareResetFilterCall(1, [this.comp1, this.comp2]);
    });

    test('Filtering should be case insensitive.', function () {
        this.filterModel.set("contains", "SeCOnD");
        this.compareResetFilterCall(0, [this.comp2]);

        this.filterModel.set("contains", "DESC");
        this.compareResetFilterCall(1, [this.comp1]);
    });

    test('Filtering should find strings in the middle of text.', function () {
        this.filterModel.set("contains", "cond");
        this.compareResetFilterCall(0, [this.comp2]);

        this.filterModel.set("contains", "description");
        this.compareResetFilterCall(1, [this.comp1]);
    });

});

