define("jira/projects/components/analytics", [
    "jira/api/projects"
], function (
    Projects
) {
    "use strict";

    var jiraProjectType = Projects.getCurrentProjectType();

    var triggerEvent = function(key, data) {
        data = data || {};
        data.projectType = jiraProjectType;
        AJS.trigger('analyticsEvent', {
            name: key,
            data: data
        })
    };

    return {
        listenForCommonEvents: function (controller) {
            controller.on({
                "navigateEvent": function () {
                    triggerEvent("jira.projects.components.navigate");
                },
                "infiniteScrollEvent": function (data) {
                    triggerEvent("jira.projects.components.infinite.scroll", data);
                },
                "componentsLoadedEvent": function (data) {
                    triggerEvent("jira.projects.components.loaded", data);
                },
                "emptyViewEvent": function () {
                    triggerEvent("jira.projects.components.empty.view");
                },
                "learnMoreClickEvent": function () {
                    triggerEvent("jira.projects.components.learn.more.click");
                }
            });
        },

        listenForActionsOnItem: function (controller) {
            controller.on({
                "createItemEvent": function (data) {
                    triggerEvent("jira.projects.components.item.create", data);
                },
                "searchItemEvent": function () {
                    triggerEvent("jira.projects.components.item.search");
                },
                "removeItemEvent": function () {
                    triggerEvent("jira.projects.components.item.remove");
                },
                /**
                 * After this event `removeItemEvent` will be triggered.
                 */
                "swapItemEvent": function () {
                    triggerEvent("jira.projects.components.item.swap");
                }
            });
        },

        listenForClicksOnItem: function (controller) {
            controller.on({
                "clickOnNameEvent": function () {
                    triggerEvent("jira.projects.components.click.name");
                },
                "clickOnIssueEvent": function () {
                    triggerEvent("jira.projects.components.click.issue");
                },
                "clickOnRetryEvent": function (data) {
                    var componentId = data.model && (data.model.id || data.model.cid);
                    triggerEvent("jira.projects.components.click.retry", {
                        "componentId": componentId
                    });
                }
            });
        }
    };
});
