(function() {
    "use strict";

    /**
     * Get query sting param's value from the url. Optionally hash can be included in the search.
     *
     * @param name {string} The name of the parameter we're retrieving the value for.
     * @param includeHash {boolean} Whether to search for the parameter also in the hash fragment.
     *
     * @returns {string} The value of the parameter (preferring the one in the hash fragment if we're searching there, too).
     * or <tt>undefined</tt> if the parameter is not present.
     */
    function getQueryStringParam(name, includeHash, location) {
        location = location || window.location;
        if (!name) {
            return;
        }
        var params = location.search.substr(1).split('&');
        if (includeHash) {
            params = params.concat(location.hash.substr(1).split('&'));
        }
        for (var i = params.length - 1; i >= 0; i--) {
            var param = params[i].split('=');
            if (param.length != 2) continue;
            if (name === param[0]) {
                return decodeURIComponent(param[1].replace(/\+/g, " "));
            }
        }
    }

    AJS.namespace("JIRA.Projects.AbstractList.NavigationUtils");
    JIRA.Projects.AbstractList.NavigationUtils.getQueryStringParam = getQueryStringParam;
})();
