AJS.test.require(["com.atlassian.jira.jira-projects-plugin:abstract-list-page"], function(){
    "use strict";

    module('JIRA.Projects.AbstractList.NavigationUtils.getQueryStringParam', {
        teardown: function () {
            JIRA.Projects.AbstractList.NavigationUtils.getQueryStringParam.location = window.location;
        }
    });

    test('Should return the value of requested parameter.', function () {
        var location = {
            search: "?param=value&param2=value2"
        };

        equal(JIRA.Projects.AbstractList.NavigationUtils.getQueryStringParam("param", false, location), "value");
        equal(JIRA.Projects.AbstractList.NavigationUtils.getQueryStringParam("param2", false, location), "value2");
    });

    test('Should return undefined if there are no params.', function () {
        var location = {
            search: ""
        };

        strictEqual(JIRA.Projects.AbstractList.NavigationUtils.getQueryStringParam("param", false, location), undefined);
    });

    test('Should return undefined if param is not present.', function () {
        var location = {
            search: "?param=value"
        };

        strictEqual(JIRA.Projects.AbstractList.NavigationUtils.getQueryStringParam("param2", false, location), undefined);
    });

    test('Should include location hash in the search if said so.', function () {
        var location = {
            search: "?param=value",
            hash: "#hash=true"
        };

        equal(JIRA.Projects.AbstractList.NavigationUtils.getQueryStringParam("param", true, location), "value");
        equal(JIRA.Projects.AbstractList.NavigationUtils.getQueryStringParam("hash", true, location), "true");
    });

    test('Should return undefined for falsy parameter key.', function () {
        var location = {
            search: "?param=value&param=value2",
            hash: "#param=value3"
        };

        strictEqual(JIRA.Projects.AbstractList.NavigationUtils.getQueryStringParam("", false, location), undefined);
        strictEqual(JIRA.Projects.AbstractList.NavigationUtils.getQueryStringParam(undefined, false, location), undefined);
    });

    test('Should return last if there are more than one parameter with the same name.', function () {
        var location = {
            search: "?param=value&param=value2",
            hash: "#param=value3"
        };

        equal(JIRA.Projects.AbstractList.NavigationUtils.getQueryStringParam("param", false, location), "value2");
        equal(JIRA.Projects.AbstractList.NavigationUtils.getQueryStringParam("param", true, location), "value3");
    });

    test('Should properly decode parameter values.', function () {
        var location = {
            search: "?param=%3Cvalue%3E&param2=some+text&param3=%3Csome+value%3E"
        };

        equal(JIRA.Projects.AbstractList.NavigationUtils.getQueryStringParam("param", false, location), "<value>", "Should URI-decode the value.");
        equal(JIRA.Projects.AbstractList.NavigationUtils.getQueryStringParam("param2", false, location), "some text", "Should change + to spaces.");
        equal(JIRA.Projects.AbstractList.NavigationUtils.getQueryStringParam("param3", false, location), "<some value>", "Should URI-decode the value and change + to space.");
    });

    test('Should handle empty search and hash segments.', function () {
        var location = {
            search: "?&&=&=foo",
            hash: "#&&=&=bar"
        };

        strictEqual(JIRA.Projects.AbstractList.NavigationUtils.getQueryStringParam("foo", false, location), undefined);
        strictEqual(JIRA.Projects.AbstractList.NavigationUtils.getQueryStringParam("bar", true, location), undefined);
    });
});
