AJS.test.require(["com.atlassian.jira.jira-projects-plugin:abstract-list-page"],function(){module("JIRA.Projects.AbstractList.NavigationUtils.getQueryStringParam",{teardown:function(){JIRA.Projects.AbstractList.NavigationUtils.getQueryStringParam.location=window.location}});test("Should return the value of requested parameter.",function(){var a={search:"?param=value&param2=value2"};equal(JIRA.Projects.AbstractList.NavigationUtils.getQueryStringParam("param",false,a),"value");equal(JIRA.Projects.AbstractList.NavigationUtils.getQueryStringParam("param2",false,a),"value2")});test("Should return undefined if there are no params.",function(){var a={search:""};strictEqual(JIRA.Projects.AbstractList.NavigationUtils.getQueryStringParam("param",false,a),undefined)});test("Should return undefined if param is not present.",function(){var a={search:"?param=value"};strictEqual(JIRA.Projects.AbstractList.NavigationUtils.getQueryStringParam("param2",false,a),undefined)});test("Should include location hash in the search if said so.",function(){var a={search:"?param=value",hash:"#hash=true"};equal(JIRA.Projects.AbstractList.NavigationUtils.getQueryStringParam("param",true,a),"value");equal(JIRA.Projects.AbstractList.NavigationUtils.getQueryStringParam("hash",true,a),"true")});test("Should return undefined for falsy parameter key.",function(){var a={search:"?param=value&param=value2",hash:"#param=value3"};strictEqual(JIRA.Projects.AbstractList.NavigationUtils.getQueryStringParam("",false,a),undefined);strictEqual(JIRA.Projects.AbstractList.NavigationUtils.getQueryStringParam(undefined,false,a),undefined)});test("Should return last if there are more than one parameter with the same name.",function(){var a={search:"?param=value&param=value2",hash:"#param=value3"};equal(JIRA.Projects.AbstractList.NavigationUtils.getQueryStringParam("param",false,a),"value2");equal(JIRA.Projects.AbstractList.NavigationUtils.getQueryStringParam("param",true,a),"value3")});test("Should properly decode parameter values.",function(){var a={search:"?param=%3Cvalue%3E&param2=some+text&param3=%3Csome+value%3E"};equal(JIRA.Projects.AbstractList.NavigationUtils.getQueryStringParam("param",false,a),"<value>","Should URI-decode the value.");equal(JIRA.Projects.AbstractList.NavigationUtils.getQueryStringParam("param2",false,a),"some text","Should change + to spaces.");equal(JIRA.Projects.AbstractList.NavigationUtils.getQueryStringParam("param3",false,a),"<some value>","Should URI-decode the value and change + to space.")});test("Should handle empty search and hash segments.",function(){var a={search:"?&&=&=foo",hash:"#&&=&=bar"};strictEqual(JIRA.Projects.AbstractList.NavigationUtils.getQueryStringParam("foo",false,a),undefined);strictEqual(JIRA.Projects.AbstractList.NavigationUtils.getQueryStringParam("bar",true,a),undefined)})});