define("jira/projects/abstract-list/table-layout-view", [
    "jira/projects/libs/marionette",
    'backbone'
], function(
    Marionette,
    Backbone
) {
    "use strict";

    var TableLayoutView = Marionette.LayoutView.extend({
        regions: {
            itemsRegion: ".items"
        },

        initialize: function (options) {
            this.collection = options.collection;
            this.submitController = options.submitController;
        },

        onRender: function () {
            this.itemsRegion.attachHtml = this._attachHtmlReplaceRegionWrapper;

            var collectionView = new this.ItemCollectionView({
                collection: this.collection,
                submitController: this.submitController,
                className: 'items'
            });

            this.itemsRegion.show(collectionView);
        },

        _attachHtmlReplaceRegionWrapper: function(view){
            this.$el.replaceWith(view.el);
        }
    });

    return TableLayoutView;
});
