(function() {
    "use strict";

    AJS.namespace("JIRA.Projects.AbstractList.PaginationView");
    JIRA.Projects.AbstractList.PaginationView = JIRA.Projects.Libs.Marionette.ItemView.extend({
        template: JIRA.Projects.AbstractList.Templates.pagination,
        ui: {
            page: "li a"
        },
        events: {
            "click @ui.page": "clickPage"
        },
        collectionEvents: {
            reset: "render"
        },
        modelEvents: {
            change: "render"
        },
        onRender: function onRender() {
            this.unwrapTemplate();
        },
        serializeData: function() {
            var url = JIRA.Projects.AbstractList.NavigationUtils.getRoot() + this.model.getFilterQueryStringParams();
            var data =_.extend({
                url: url
            }, this.collection.state);
            data.firstPage = Math.max(data.currentPage - 5, data.firstPage);
            data.totalPages = data.lastPage;
            data.lastPage = Math.min(data.currentPage + 5, data.lastPage);
            return data;
        },
        clickPage: function clickPage(e) {
            e.preventDefault();
            var pageNumber = +AJS.$(e.target).attr("data-page");
            if (pageNumber) {
                JIRA.Projects.AbstractList.NavigationUtils.navigate(this.model.getFilterQueryStringParams() + "&page=" + pageNumber);
                this.collection.getPage(pageNumber);
                this.trigger("navigate", pageNumber);
            }
        }
    });
})();