(function() {
    "use strict";
    var URI = require('atlassian/libs/uri-1.14.1');

    AJS.namespace("JIRA.Projects.AbstractList.NavigationUtils");
    JIRA.Projects.AbstractList.NavigationUtils.pushStateSupported = !!history.pushState;
    JIRA.Projects.AbstractList.NavigationUtils.getBackboneHistoryRoot = function getRoot() {
        return (JIRA.Projects.AbstractList.NavigationUtils.pushStateSupported)
                ? ""
                : JIRA.Projects.AbstractList.NavigationUtils.getRoot();
    };
    JIRA.Projects.AbstractList.NavigationUtils.getRoot = function getRoot() {
        var selectedItem = JIRA.Projects.AbstractList.NavigationUtils.getQueryStringParam("selectedItem");
        return document.location.pathname + (selectedItem ? ("?selectedItem=" + selectedItem) : '?');
    };
    JIRA.Projects.AbstractList.NavigationUtils.navigate = function navigate(location) {
        if (JIRA.Projects.AbstractList.NavigationUtils.pushStateSupported) {
            location = JIRA.Projects.AbstractList.NavigationUtils.getRoot() + location;
        }
        Backbone.history.navigate(location);
    };
    JIRA.Projects.AbstractList.NavigationUtils.append = function append(name, value) {
        var uri = new URI(location.href);
        uri = uri.addSearch(name, value);

        history.replaceState(null, "", uri.href());
    };
})();
