define('jira/projects/abstract-list/item-collection-view', [
    "jira/projects/abstract-list/effects",
    "jira/projects/libs/marionette",
    "jira/projects/abstract-list/lazy-loading-collection",
    "jquery",
    "underscore"
], function(
    Effects,
    Marionette,
    LazyLoadingCollection,
    $,
    _
) {
    "use strict";

    var ItemCollectionView = Marionette.CollectionView.extend({
        tagName: 'tbody',

        initialize: function(options) {
            if (! options.collection instanceof LazyLoadingCollection) {
                throw "Collection should extend LazyLoadingCollection"
            }
            var _checkScroll = _.debounce(this._checkScroll, ItemCollectionView.SCROLL_DEBOUNCE, true).bind(this);
            $(window).on("scroll.infiniteScroll", _checkScroll);
            this.checkInterval = setInterval(_checkScroll, ItemCollectionView.CHECK_INTERVAL);
        },

        onDestroy: function() {
            $(window).off("scroll.infiniteScroll");
            clearInterval(this.checkInterval);
        },

        _checkScroll: function(e) {
            var last = this.children.last();
            if (last.$el.isInView()) {
                this._nextPage(e);
            }
            JIRA.trace("jira.projects.scroll.checked");
        },

        _nextPage: function clickPage(e) {
            e && e.preventDefault();
            var effective = this.collection.nextPage();
            if (effective) {
                this.trigger("infiniteScrollEvent", {
                    elementsLoaded: this.collection.elementsLeft().elementsLoaded,
                    elementsLeft: this.collection.elementsLeft().elementsLeft
                });
            }
        },

        _onCollectionRemove: Effects.onCollectionRemove
    });

    ItemCollectionView.SCROLL_DEBOUNCE = 50;
    ItemCollectionView.CHECK_INTERVAL = 1000;

    return ItemCollectionView;
});