(function() {
    "use strict";

    AJS.namespace("JIRA.Projects.AbstractList.FilterModel");
    JIRA.Projects.AbstractList.FilterModel = Backbone.Model.extend({
        filterAttributes: [],
        initialize: function initialize(options) {
            this.pageableCollection = options.pageableCollection;
            delete this.attributes.pageableCollection; // silently get rid of the set model attribute
        },
        filterCollection: function filterCollection() {
            var filtered = this.pageableCollection.originalCollection;
            this.pageableCollection.fullCollection.reset(filtered);
            this.pageableCollection.getPage("first");
        },
        navigate: function navigate() {
            JIRA.Projects.AbstractList.NavigationUtils.navigate(this.getFilterQueryStringParams());
            this.trigger("navigate");
        },
        getFilterQueryStringParams: function getFilterQueryStringParams() {
            var filter = this.filterAttributes
                    .reduce(function (previous, current) {
                        var param = this.get(current);
                        if (param) {
                            return previous + "&" + encodeURIComponent(current) + "=" + encodeURIComponent(param);
                        }
                        return previous;
                    }.bind(this), "");
            if (!JIRA.Projects.AbstractList.NavigationUtils.pushStateSupported) {
                filter = filter.substr(1)
            }
            return filter;
        }
    });

})();
