/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.web.filter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class BrowseProjectUrlHelper {
    static final String VERSION = "/fixforversion/";
    static final String COMPONENT = "/component/";
    static final long CURRENT_PROJECT_AVATAR = -1L;
    private static final Pattern PROJECT_AVATAR = Pattern.compile(".*\\/icon\\/(?:(\\d+)_[^/]+)?");
    private static final String AVATAR = "/icon/";
    private final String pathInfo;
    private final String projectKey;
    private final Long componentId;
    private final Long versionId;
    private final Long projectAvatarId;

    public BrowseProjectUrlHelper(String pathInfo) {
        if (pathInfo == null || pathInfo.length() < 2) {
            throw new IllegalArgumentException("path is invalid");
        }
        this.pathInfo = pathInfo;
        this.componentId = this.findIdFor(COMPONENT);
        this.versionId = this.findIdFor(VERSION);
        this.projectAvatarId = this.findProjectAvatarId();
        this.projectKey = this.extractProjectKey();
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public Long getVersionId() {
        return this.versionId;
    }

    public Long getComponentId() {
        return this.componentId;
    }

    public Long getProjectAvatarId() {
        return this.projectAvatarId;
    }

    Long findProjectAvatarId() {
        Long avatarId = null;
        Matcher matcher = PROJECT_AVATAR.matcher(this.pathInfo);
        if (matcher.matches()) {
            if (matcher.groupCount() == 1) {
                try {
                    avatarId = new Long(matcher.group(1));
                }
                catch (NumberFormatException e) {
                    avatarId = -1L;
                }
            } else {
                avatarId = -1L;
            }
        }
        return avatarId;
    }

    private String extractProjectKey() {
        String[] browseSubparts;
        String path = this.pathInfo.substring(1, this.pathInfo.length());
        for (String browseSubpart : browseSubparts = new String[]{VERSION, COMPONENT, AVATAR}) {
            int index = path.indexOf(browseSubpart);
            if (index < 0) continue;
            return path.substring(0, index);
        }
        return path;
    }

    private Long findIdFor(String foo) {
        int versionIndex = this.pathInfo.indexOf(foo);
        if (versionIndex < 0) {
            return null;
        }
        try {
            return new Long(this.pathInfo.substring(versionIndex + foo.length()).replace("/", ""));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

