/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.web;

import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.plugin.versionpanel.BrowseVersionContext;
import com.atlassian.jira.plugin.versionpanel.VersionTabPanel;
import com.atlassian.jira.plugin.versionpanel.VersionTabPanelModuleDescriptor;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.projects.api.sidebar.ProjectSidebarRenderer;
import com.atlassian.jira.projects.legacy.versionpanel.BrowseVersionContextImpl;
import com.atlassian.jira.projects.page.release.VersionsJsonableProvider;
import com.atlassian.jira.projects.web.BrowseProjectContextProvider;
import com.atlassian.jira.web.action.AbstractPluggableTabPanelAction;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.pagebuilder.JiraPageBuilderService;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atlassian.webresource.api.assembler.RequiredResources;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

@Scanned
public class BrowseProjectVersion
extends AbstractPluggableTabPanelAction<VersionTabPanelModuleDescriptor> {
    private final ProjectManager projectManager;
    private final PageBuilderService pageBuilderService;
    private final BrowseProjectContextProvider browseProjectContextProvider;
    private final ProjectSidebarRenderer projectSidebarRenderer;
    private final VersionsJsonableProvider versionsJsonableProvider;
    private BrowseVersionContext versionContext;
    public static final String SUCCESS_TAB = "successtab";
    public static final String SUCCESS_WITH_SIDEBAR = "successsidebar";
    private Long versionId;
    private Long projectId;
    private boolean contentOnly;

    @Inject
    public BrowseProjectVersion(@ComponentImport PluginAccessor pluginAccessor, @ComponentImport ProjectManager projectManager, @ComponentImport JiraPageBuilderService pageBuilderService, BrowseProjectContextProvider browseProjectContextProvider, ProjectSidebarRenderer projectSidebarRenderer, VersionsJsonableProvider versionsJsonableProvider) {
        super(pluginAccessor);
        this.projectSidebarRenderer = projectSidebarRenderer;
        this.versionsJsonableProvider = versionsJsonableProvider;
        this.browseProjectContextProvider = browseProjectContextProvider;
        this.pageBuilderService = pageBuilderService;
        this.projectManager = projectManager;
    }

    protected String doExecute() {
        Version version;
        Project newProject;
        Project project = this.getSelectedProjectObject();
        if (this.projectId != null && (newProject = this.projectManager.getProjectObj(this.projectId)) != null && !newProject.equals(project)) {
            this.log.info((Object)"Specified project id to browse, but it is diff to current project.  Most prob a permission violation (or it doesn't exist)");
            return "permissionviolation";
        }
        if (project == null) {
            return this.getRedirect("/secure/BrowseProjects.jspa");
        }
        this.tagMauEventWithProject(project);
        if (this.versionId != null && (version = this.getVersionManager().getVersion(this.versionId)) != null && version.getProjectObject().getId().equals(project.getId())) {
            RequiredResources resources = this.pageBuilderService.assembler().resources();
            resources.requireContext("jira.browse").requireContext("jira.browse.version");
            if (this.contentOnly) {
                return SUCCESS_TAB;
            }
            resources.requireWebResource("com.atlassian.jira.jira-projects-plugin:browseversion-overrides");
            this.pageBuilderService.assembler().data().requireData("com.atlassian.jira.project.browse.version:versions", this.versionsJsonableProvider.getAllVersions(this.getSelectedProject()));
            this.pageBuilderService.assembler().data().requireData("com.atlassian.jira.project.browse.version:selectedVersionId", Long.toString(this.versionId));
            resources.requireContext("jira.project.sidebar");
            return SUCCESS_WITH_SIDEBAR;
        }
        return this.getRedirect("/browse/" + project.getKey());
    }

    public Long getId() {
        return this.projectId;
    }

    public void setId(Long id) {
        this.projectId = id;
        this.setSelectedProjectId(id);
    }

    public void setVersionId(Long id) {
        this.versionId = id;
        this.versionContext = null;
    }

    @ActionViewData
    public String getTabLabel() {
        boolean descriptorNoTitle;
        VersionTabPanelModuleDescriptor tabPanel = (VersionTabPanelModuleDescriptor)this.getSelectedTabPanel();
        boolean bl = descriptorNoTitle = tabPanel.getParams().containsKey("noTitle") && Boolean.parseBoolean((String)tabPanel.getParams().get("noTitle"));
        if (tabPanel != null && !descriptorNoTitle) {
            return tabPanel.getLabel();
        }
        if (tabPanel == null) {
            this.log.warn((Object)"Either unknown tab specified or no tab specified and no tabs in system");
        }
        return null;
    }

    @ActionViewData
    public String getTabHtml() throws IOException {
        String tabHtml;
        VersionTabPanelModuleDescriptor tabPanelDescriptor = (VersionTabPanelModuleDescriptor)this.getSelectedTabPanel();
        if (tabPanelDescriptor == null) {
            this.log.warn((Object)("Unknown tab panel '" + this.getSelectedTab() + "' has been specified."));
            return "";
        }
        VersionTabPanel panel = (VersionTabPanel)tabPanelDescriptor.getModule();
        try {
            tabHtml = panel.getHtml((BrowseContext)this.getVersionContext());
        }
        catch (Exception e) {
            this.log.info((Object)"Exception in version tab panel plugin", (Throwable)e);
            tabHtml = "";
        }
        return tabHtml;
    }

    @ActionViewData
    public String getSidebarHtml() throws IOException {
        return this.projectSidebarRenderer.render(this.getSelectedProject(), "com.atlassian.jira.jira-projects-plugin:release-page");
    }

    @ActionViewData(value="success")
    public Map<String, Object> getContext() {
        return this.browseProjectContextProvider.getContext(this.getSelectedProjectObject(), this.getSelected());
    }

    @ActionViewData(value="successsidebar")
    public Map<String, Object> getSidebarContext() {
        return this.getContext();
    }

    @ActionViewData
    public List<VersionTabPanelModuleDescriptor> getVersionTabPanels() {
        return this.getTabPanels();
    }

    @ActionViewData
    public Version getVersion() {
        return this.versionId == null ? null : this.getVersionManager().getVersion(this.versionId);
    }

    @ActionViewData
    public NextPreviousVersion getNextAndPreviousVersions() {
        Version currentVersion = this.getVersion();
        if (currentVersion != null) {
            Collection versions = this.getVersionManager().getVersionsUnarchived(currentVersion.getProjectObject().getId());
            Version previous = null;
            Version next = null;
            Iterator versionIterator = versions.iterator();
            while (versionIterator.hasNext()) {
                Version version = (Version)versionIterator.next();
                if (version.equals(currentVersion)) {
                    if (versionIterator.hasNext()) {
                        next = (Version)versionIterator.next();
                    }
                    return new NextPreviousVersion(previous, next);
                }
                previous = version;
            }
        }
        return new NextPreviousVersion(null, null);
    }

    protected boolean isTabPanelHidden(VersionTabPanelModuleDescriptor descriptor) throws PermissionException {
        return !((VersionTabPanel)descriptor.getModule()).showPanel((BrowseContext)this.getVersionContext());
    }

    protected List<VersionTabPanelModuleDescriptor> getTabPanelModuleDescriptors() {
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(VersionTabPanelModuleDescriptor.class);
    }

    private BrowseVersionContext getVersionContext() {
        if (this.versionContext == null) {
            this.versionContext = new BrowseVersionContextImpl(this.getVersion(), this.getLoggedInUser());
        }
        return this.versionContext;
    }

    public void setContentOnly(boolean contentOnly) {
        this.contentOnly = contentOnly;
    }

    public static class NextPreviousVersion {
        private final Version next;
        private final Version previous;

        public NextPreviousVersion(Version previous, Version next) {
            this.next = next;
            this.previous = previous;
        }

        public Version getNext() {
            return this.next;
        }

        public Version getPrevious() {
            return this.previous;
        }
    }
}

