/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.unlicensed;

import com.atlassian.application.api.Application;
import com.atlassian.fugue.Option;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.project.type.ProjectTypeManager;
import com.atlassian.jira.projects.unlicensed.UnlicensedProjectPageRenderer;
import com.atlassian.jira.projects.util.TemplateRenderer;
import com.atlassian.jira.util.JiraContactHelper;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.assembler.RequiredResources;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class DefaultUnlicensedProjectPageRenderer
implements UnlicensedProjectPageRenderer {
    static final String PROJECT_TYPE_UNLICENSED_CONTEXT = "project.type.unlicensed";
    static final String RESOURCE_KEY = "com.atlassian.jira.jira-projects-plugin:unlicensed-project-type";
    static final String TEMPLATE_KEY = "JIRA.Projects.Unlicensed.Templates.unlicensedViewUsingAppName";
    private final TemplateRenderer renderer;
    private final JiraContactHelper jiraContactHelper;
    private final HelpUrls helpUrls;
    private final ProjectTypeManager projectTypeManager;

    @Autowired
    public DefaultUnlicensedProjectPageRenderer(TemplateRenderer renderer, @ComponentImport JiraContactHelper jiraContactHelper, @ComponentImport HelpUrls helpUrls, @ComponentImport ProjectTypeManager projectTypeManager) {
        this.renderer = renderer;
        this.jiraContactHelper = jiraContactHelper;
        this.helpUrls = helpUrls;
        this.projectTypeManager = projectTypeManager;
    }

    @Nonnull
    public String render(@Nonnull RequiredResources requiredResources, @Nonnull ProjectTypeKey projectTypeKey) {
        return this.render(requiredResources, projectTypeKey, (Option<String>)Option.none());
    }

    @Nonnull
    public String render(@Nonnull RequiredResources requiredResources, @Nonnull ProjectTypeKey projectTypeKey, @Nonnull String redirectUrl) {
        return this.render(requiredResources, projectTypeKey, (Option<String>)Option.option((Object)redirectUrl));
    }

    private String render(RequiredResources requiredResources, ProjectTypeKey projectTypeKey, Option<String> redirectUrl) {
        requiredResources.requireContext(PROJECT_TYPE_UNLICENSED_CONTEXT);
        return this.renderer.render(RESOURCE_KEY, TEMPLATE_KEY, (Map<String, Object>)ImmutableMap.of((Object)"applicationName", (Object)this.getApplicationName(projectTypeKey), (Object)"projectTypesInfoUrl", (Object)this.helpUrls.getUrl("project.types.learn.more").getUrl(), (Object)"projectRedirectUrl", (Object)redirectUrl.getOrElse((Object)""), (Object)"requestApplicationAccessUrl", (Object)this.getApplicationAccessUrl()));
    }

    private String getApplicationName(ProjectTypeKey projectTypeKey) {
        Application application = (Application)this.projectTypeManager.getApplicationWithType(projectTypeKey).getOrNull();
        if (application != null) {
            return application.getName();
        }
        return "";
    }

    private String getApplicationAccessUrl() {
        if (this.jiraContactHelper.isAdministratorContactFormEnabled()) {
            return this.jiraContactHelper.getAdministratorContactLink(this.getContextPath());
        }
        return "";
    }

    @VisibleForTesting
    protected String getContextPath() {
        return ExecutingHttpRequest.get().getContextPath();
    }
}

