/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.tabpanel;

import com.atlassian.jira.plugin.projectpanel.ProjectTabPanel;
import com.atlassian.jira.plugin.projectpanel.ProjectTabPanelModuleDescriptor;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.projects.util.BrowseContextFactory;
import com.atlassian.ozymandias.PluginPointVisitor;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.Lists;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TabPanelService {
    private final PluginAccessor pluginAccessor;
    private final BrowseContextFactory browseContextFactory;

    @Autowired
    public TabPanelService(@ComponentImport PluginAccessor pluginAccessor, BrowseContextFactory browseContextFactory) {
        this.pluginAccessor = pluginAccessor;
        this.browseContextFactory = browseContextFactory;
    }

    public Iterable<ProjectTabPanelModuleDescriptor> getVisibleTabPanelDescriptorsForProject(String key) {
        BrowseContext context = this.browseContextFactory.create(key);
        CollectVisible collectVisible = new CollectVisible(context);
        SafePluginPointAccess.to((PluginAccessor)this.pluginAccessor).forType(ProjectTabPanelModuleDescriptor.class, (PluginPointVisitor)collectVisible);
        return collectVisible.descriptors;
    }

    private static class CollectVisible
    implements PluginPointVisitor<ProjectTabPanelModuleDescriptor, ProjectTabPanel> {
        private final BrowseContext context;
        private final List<ProjectTabPanelModuleDescriptor> descriptors;

        public CollectVisible(BrowseContext context) {
            this.context = context;
            this.descriptors = Lists.newArrayList();
        }

        public void visit(ProjectTabPanelModuleDescriptor moduleDescriptor, ProjectTabPanel module) {
            if (module.showPanel(this.context)) {
                this.descriptors.add(moduleDescriptor);
            }
        }

        public List<ProjectTabPanelModuleDescriptor> result() {
            return this.descriptors;
        }
    }
}

