/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.sidebar.lastvisited;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.api.sidebar.navigation.NavigationItem;
import com.atlassian.jira.projects.sidebar.navigation.SidebarNavigationService;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LastVisitedItemUrlProvider {
    private final SidebarNavigationService sidebarNavigationService;
    static final List<String> AGILE_WEB_ITEMS = Arrays.asList("com.pyxis.greenhopper.jira:project-sidebar-plan-scrum", "com.pyxis.greenhopper.jira:project-sidebar-work-scrum", "com.pyxis.greenhopper.jira:project-sidebar-work-kanban");
    static final String DEFAULT_AGILE_WEB_ITEM = "com.pyxis.greenhopper.jira:project-work-default-page";

    @Autowired
    public LastVisitedItemUrlProvider(SidebarNavigationService sidebarNavigationService) {
        this.sidebarNavigationService = sidebarNavigationService;
    }

    public Optional<String> getLastVisitedItemUrl(Optional<NavigationItem> lastVisitedNavItemOptional, Project project) {
        Optional<String> lastVisitedItemId = lastVisitedNavItemOptional.map(NavigationItem::getId);
        if (lastVisitedItemId.isPresent()) {
            if (AGILE_WEB_ITEMS.contains(lastVisitedItemId.get())) {
                Optional<NavigationItem> defaultAgileNavItem = this.sidebarNavigationService.getNavigationItemById(DEFAULT_AGILE_WEB_ITEM, project);
                return defaultAgileNavItem.map(NavigationItem::getHref);
            }
            return lastVisitedNavItemOptional.map(NavigationItem::getHref);
        }
        return Optional.empty();
    }
}

