/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.sidebar.content;

import com.atlassian.jira.projects.api.sidebar.content.ContentRenderer;
import com.atlassian.jira.projects.sidebar.navigation.WebFragmentContextService;
import com.atlassian.jira.projects.util.TemplateRenderer;
import com.atlassian.jira.projects.util.WebPanelRenderer;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class ContentRendererImpl
implements ContentRenderer {
    private static final String RESOURCE_KEY = "com.atlassian.jira.jira-projects-plugin:sidebar-content-soy";
    private static final String TEMPLATE_KEY = "JIRA.Projects.Sidebar.Content.Templates.content";
    private final TemplateRenderer renderer;
    private final WebFragmentContextService webFragmentContextService;
    private final WebPanelRenderer webPanelRenderer;

    @Autowired
    public ContentRendererImpl(TemplateRenderer renderer, WebFragmentContextService webFragmentContextService, WebPanelRenderer webPanelRenderer) {
        this.renderer = renderer;
        this.webFragmentContextService = webFragmentContextService;
        this.webPanelRenderer = webPanelRenderer;
    }

    public String render(String location, Map<String, Object> additionalContext) {
        Map<String, Object> context = this.defaultContext();
        context.putAll(additionalContext);
        String content = (String)this.webPanelRenderer.renderWebPanels(location, context).getOrElse((Object)"");
        return this.renderer.render(RESOURCE_KEY, TEMPLATE_KEY, (Map<String, Object>)ImmutableMap.of((Object)"content", (Object)content));
    }

    private Map<String, Object> defaultContext() {
        return Maps.newHashMap(this.webFragmentContextService.getDefaultWebFragmentContext());
    }
}

