/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.sidebar.ancillary;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.api.context.AncillaryLinksWebPanelContextProvider;
import com.atlassian.jira.projects.api.context.ProjectContextPopulator;
import com.atlassian.jira.projects.api.sidebar.navigation.NavigationItemService;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class AncillaryLinksWebPanelContextProviderImpl
implements AncillaryLinksWebPanelContextProvider {
    public static final String ANCILLARY_LINKS_SIDEBAR_SECTION_KEY = "jira.project.sidebar.ancillary.navigation";
    public static final String SETTINGS_SIDEBAR_SECTION_KEY = "jira.project.sidebar.settings.navigation";
    private final NavigationItemService navigationItemService;
    private final ProjectContextPopulator contextPopulator;

    @Autowired
    public AncillaryLinksWebPanelContextProviderImpl(NavigationItemService navigationItemService, ProjectContextPopulator contextPopulator) {
        this.navigationItemService = navigationItemService;
        this.contextPopulator = contextPopulator;
    }

    public void init(Map<String, String> map) throws PluginParseException {
    }

    public Map getContextMap(Map context) {
        Map newContext = this.contextPopulator.populateWithProject(context, (Project)Preconditions.checkNotNull(context.get("project")));
        ArrayList items = new ArrayList();
        items.addAll(this.navigationItemService.getItemsInSection(ANCILLARY_LINKS_SIDEBAR_SECTION_KEY, newContext));
        items.addAll(this.navigationItemService.getItemsInSection(SETTINGS_SIDEBAR_SECTION_KEY, newContext));
        newContext.put("items", items);
        newContext.put("id", "jira-projects-ancillary-group");
        newContext.put("tierOne", true);
        newContext.put("groupClass", "aui-sidebar-group-tier-one");
        newContext.put("title", " ");
        return newContext;
    }
}

