/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.shortcuts.upgrade;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import net.java.ao.Entity;
import net.java.ao.Preload;
import net.java.ao.schema.Indexed;
import net.java.ao.schema.StringLength;
import net.java.ao.schema.Table;

public class URLLengthUpgradeTask
implements ActiveObjectsUpgradeTask {
    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"1");
    }

    public void upgrade(ModelVersion modelVersion, ActiveObjects activeObjects) {
        activeObjects.migrate(new Class[]{IntermediateMutableProjectShortcut.class});
        if (modelVersion.isNewerThan(this.getModelVersion())) {
            return;
        }
        for (IntermediateMutableProjectShortcut projectShortcut : (IntermediateMutableProjectShortcut[])activeObjects.find(IntermediateMutableProjectShortcut.class)) {
            projectShortcut.setShortcutUrl(projectShortcut.getUrl());
            projectShortcut.save();
        }
    }

    @Preload
    @Table(value="shortcut")
    public static interface IntermediateMutableProjectShortcut
    extends Entity {
        public String getName();

        public void setName(String var1);

        public String getUrl();

        public void setUrl(String var1);

        @StringLength(value=-1)
        public String getShortcutUrl();

        public void setShortcutUrl(String var1);

        @Indexed
        public Long getProjectId();

        public void setProjectId(Long var1);
    }
}

