/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.shortcuts;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.ProjectService;
import com.atlassian.jira.projects.shortcuts.ProjectShortcut;
import com.atlassian.jira.projects.shortcuts.ShortcutsService;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="project/{projectKey}/shortcut")
@AnonymousAllowed
@Scanned
public class ShortcutsResource {
    private final ProjectService projectService;
    private final ShortcutsService shortcutsService;
    private final JiraAuthenticationContext authContext;
    public static final Function<ProjectShortcut, ProjectShortcutBean> SHORTCUT_TO_BEAN = new Function<ProjectShortcut, ProjectShortcutBean>(){

        public ProjectShortcutBean apply(ProjectShortcut input) {
            return new ProjectShortcutBean(input.getId().toString(), input.getName(), input.getUrl(), input.getIcon());
        }
    };
    public static final Function<com.atlassian.jira.util.ErrorCollection, Response> ERROR_COLLECTION_TO_RESPONSE = new Function<com.atlassian.jira.util.ErrorCollection, Response>(){

        public Response apply(com.atlassian.jira.util.ErrorCollection input) {
            ErrorCollection ec = ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)input);
            return Response.status((int)ec.getStatus()).entity((Object)ec).build();
        }
    };

    public ShortcutsResource(ProjectService projectService, ShortcutsService shortcutsService, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext) {
        this.projectService = projectService;
        this.authContext = jiraAuthenticationContext;
        this.shortcutsService = shortcutsService;
    }

    @GET
    public Response getAll(@PathParam(value="projectKey") String projectKey) {
        Either<Response, Project> project = this.getProject(projectKey);
        if (project.isLeft()) {
            return (Response)project.left().get();
        }
        List shortcuts = this.shortcutsService.getShortcuts((Project)project.right().get(), this.authContext.getUser());
        return Response.ok((Object)ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)shortcuts, SHORTCUT_TO_BEAN))).build();
    }

    @POST
    public Response create(@PathParam(value="projectKey") String projectKey, CreateProjectShortcutBean projectShortcutBean) {
        Either<Response, Project> project = this.getProject(projectKey);
        if (project.isLeft()) {
            return (Response)project.left().get();
        }
        Either result = this.shortcutsService.addShortcut((ProjectShortcut)this.beanToShortcut(project).apply((Object)projectShortcutBean), this.authContext.getUser());
        if (result.isLeft()) {
            return (Response)ERROR_COLLECTION_TO_RESPONSE.apply(result.left().get());
        }
        return Response.status((Response.Status)Response.Status.CREATED).entity(SHORTCUT_TO_BEAN.apply(result.right().get())).build();
    }

    @GET
    @Path(value="/{id}")
    public Response get(@PathParam(value="projectKey") String projectKey, @PathParam(value="id") Integer id) {
        Either<Response, Project> project = this.getProject(projectKey);
        if (project.isLeft()) {
            return (Response)project.left().get();
        }
        Either result = this.shortcutsService.getShortcut(id, this.authContext.getUser());
        if (result.isLeft()) {
            return (Response)ERROR_COLLECTION_TO_RESPONSE.apply(result.left().get());
        }
        return Response.ok((Object)SHORTCUT_TO_BEAN.apply(result.right().get())).build();
    }

    @PUT
    @Path(value="/{id}")
    public Response update(@PathParam(value="projectKey") String projectKey, @PathParam(value="id") Integer id, CreateProjectShortcutBean bean) {
        Either<Response, Project> project = this.getProject(projectKey);
        if (project.isLeft()) {
            return (Response)project.left().get();
        }
        ProjectShortcut shortcut = new ProjectShortcut(id.intValue(), bean.getName(), bean.getUrl(), bean.getIcon(), (Project)project.right().get());
        Either result = this.shortcutsService.updateShortcut(shortcut, this.authContext.getUser());
        if (result.isLeft()) {
            return (Response)ERROR_COLLECTION_TO_RESPONSE.apply(result.left().get());
        }
        return Response.status((Response.Status)Response.Status.OK).entity(SHORTCUT_TO_BEAN.apply(result.right().get())).build();
    }

    @DELETE
    @Path(value="/{id}")
    public Response delete(@PathParam(value="projectKey") String projectKey, @PathParam(value="id") Integer id) {
        Either<Response, Project> project = this.getProject(projectKey);
        if (project.isLeft()) {
            return (Response)project.left().get();
        }
        Either deleteResult = this.shortcutsService.deleteShortcut(id, this.authContext.getUser());
        if (deleteResult.isRight()) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        return (Response)ERROR_COLLECTION_TO_RESPONSE.apply(deleteResult.left().get());
    }

    private Either<Response, Project> getProject(String key) {
        return this.projectService.getProject(key).left().map(ERROR_COLLECTION_TO_RESPONSE);
    }

    public Function<CreateProjectShortcutBean, ProjectShortcut> beanToShortcut(final Either<Response, Project> project) {
        return new Function<CreateProjectShortcutBean, ProjectShortcut>(){

            public ProjectShortcut apply(CreateProjectShortcutBean input) {
                return new ProjectShortcut(input.getName(), input.getUrl(), input.getIcon(), (Project)project.right().get());
            }
        };
    }

    @XmlRootElement
    public static class ProjectShortcutBean {
        @XmlElement
        private String id;
        @XmlElement
        private String name;
        @XmlElement
        private String url;
        @XmlElement
        private String icon;

        public ProjectShortcutBean(String id, String name, String url, String icon) {
            this.id = id;
            this.name = name;
            this.url = url;
            this.icon = icon;
        }

        public ProjectShortcutBean() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getIcon() {
            return this.icon;
        }

        public void setIcon(String icon) {
            this.icon = icon;
        }
    }

    @XmlRootElement
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CreateProjectShortcutBean {
        @XmlElement
        private String name;
        @XmlElement
        private String url;
        @XmlElement
        private String icon;

        public CreateProjectShortcutBean(String name, String url, String icon) {
            this.name = name;
            this.url = url;
            this.icon = icon;
        }

        public CreateProjectShortcutBean() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getIcon() {
            return this.icon;
        }

        public void setIcon(String icon) {
            this.icon = icon;
        }
    }
}

